/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.neoforge.block.render;

import io.github.foundationgames.automobility.block.model.SlopeBakedModel;
import io.github.foundationgames.automobility.block.model.SlopeUnbakedModel;
import io.github.foundationgames.automobility.neoforge.block.render.NeoForgeGeometryBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.ChunkRenderTypeSet;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.client.model.data.ModelProperty;
import net.neoforged.neoforge.common.NeoForgeConfig;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NeoForgeSlopeBakedModel
extends SlopeBakedModel {
    private static final ChunkRenderTypeSet RENDER_TYPES = ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.translucent()});
    private static final ModelProperty<TextureAtlasSprite> FRAME_SPRITE = new ModelProperty();
    private static final ModelProperty<Boolean> BORDERED_LEFT = new ModelProperty();
    private static final ModelProperty<Boolean> BORDERED_RIGHT = new ModelProperty();
    private static final ModelProperty<Integer> FRAME_COLOR = new ModelProperty();

    public NeoForgeSlopeBakedModel(TextureAtlasSprite frame, Map<BlockState, TextureAtlasSprite> frameTexOverrides, @Nullable TextureAtlasSprite plateInner, @Nullable TextureAtlasSprite plateOuter, ModelState settings, SlopeUnbakedModel.Type type) {
        super(frame, frameTexOverrides, plateInner, plateOuter, settings, type);
    }

    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        return RENDER_TYPES;
    }

    @NotNull
    public ModelData getModelData(@NotNull BlockAndTintGetter level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ModelData modelData) {
        ModelData.Builder builder = modelData.derive().with(FRAME_SPRITE, (Object)this.getFrameSprite(level, pos)).with(FRAME_COLOR, (Object)this.getFrameColor(level, pos));
        if (state.getBlock() instanceof HorizontalDirectionalBlock) {
            Direction dir = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            builder.with(BORDERED_LEFT, (Object)(level.getBlockState(pos.relative(dir.getCounterClockWise(Direction.Axis.Y))) == state ? 1 : 0)).with(BORDERED_RIGHT, (Object)(level.getBlockState(pos.relative(dir.getClockWise(Direction.Axis.Y))) == state ? 1 : 0));
        } else {
            builder.with(BORDERED_LEFT, (Object)false).with(BORDERED_RIGHT, (Object)false);
        }
        return builder.build();
    }

    private boolean unwrap(Boolean box) {
        if (box == null) {
            return false;
        }
        return box;
    }

    private int unwrap(Integer box) {
        if (box == null) {
            return -1;
        }
        return box;
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData data, @Nullable RenderType renderType) {
        if (renderType == null || this.getRenderTypes(state, rand, data).contains(renderType)) {
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            NeoForgeGeometryBuilder geo = new NeoForgeGeometryBuilder(this.settings.getRotation().getMatrix(), side, quads);
            this.buildSlopeGeometry((TextureAtlasSprite)data.get(FRAME_SPRITE), geo, this.unwrap((Integer)data.get(FRAME_COLOR)), this.unwrap((Boolean)data.get(BORDERED_LEFT)), this.unwrap((Boolean)data.get(BORDERED_RIGHT)));
            return quads;
        }
        return Collections.emptyList();
    }

    @Override
    public boolean useAmbientOcclusion() {
        return (Boolean)NeoForgeConfig.CLIENT.experimentalForgeLightPipelineEnabled.get();
    }
}

